<?php
/**
 * This file is part of supermercado_solidario
 * Copyright (C) 2014-2021 Carlos Garcia Gomez <neorazorx@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Description of clan_familiar
 *
 * @author Carlos Garcia Gomez <neorazorx@gmail.com>
 */
class clan_familiar extends fs_model
{

    /**
     * 
     * @var string
     */
    public $codclan;

    /**
     * 
     * @var string
     */
    public $nombre;

    /**
     * 
     * @var float
     */
    public $limite;

    /**
     * 
     * @var bool
     */
    public $restringido;

    /**
     * 
     * @param array $c
     */
    public function __construct($c = FALSE)
    {
        parent::__construct('clanes');
        if ($c) {
            $this->codclan = $c['codclan'];
            $this->nombre = $c['nombre'];
            $this->limite = floatval($c['limite']);
            $this->restringido = ($c['restringido'] == 't');
        } else {
            $this->codclan = NULL;
            $this->nombre = NULL;
            $this->limite = 0;
            $this->restringido = FALSE;
        }
    }

    /**
     * 
     * @return string
     */
    protected function install()
    {
        return '';
    }

    /**
     * 
     * @return string
     */
    public function url()
    {
        return 'index.php?page=ventas_clan&cod=' . $this->codclan;
    }

    /**
     * 
     * @return array
     */
    public function get_clientes()
    {
        $cliente2clan = new cliente2clan();
        return $cliente2clan->all4clan($this->codclan);
    }

    /**
     * 
     * @return float
     */
    public function gastado()
    {
        $data = $this->db->select("SELECT SUM(totaleuros) as total FROM albaranescli WHERE codcliente IN
         (SELECT codcliente FROM cliente2clan WHERE codclan = " . $this->var2str($this->codclan) . ")
            AND fecha >= " . $this->var2str(Date('1-n-Y')) . ";");
        if ($data) {
            return floatval($data[0]['total']);
        }

        return 0;
    }

    /**
     * 
     * @return float
     */
    public function pendiente()
    {
        return $this->limite - $this->gastado();
    }

    /**
     * 
     * @param string $cod
     *
     * @return boolean|\clan_familiar
     */
    public function get($cod)
    {
        $c = $this->db->select("SELECT * FROM " . $this->table_name . " WHERE codclan = " . $this->var2str($cod) . ";");
        if ($c) {
            return new clan_familiar($c[0]);
        }

        return FALSE;
    }

    /**
     * 
     * @return bool
     */
    public function exists()
    {
        if (is_null($this->codclan)) {
            return FALSE;
        }

        return $this->db->select("SELECT * FROM " . $this->table_name .
                " WHERE codclan = " . $this->var2str($this->codclan) . ";");
    }

    /**
     * 
     * @return bool
     */
    public function test()
    {
        return TRUE;
    }

    /**
     * 
     * @return bool
     */
    public function save()
    {
        if ($this->test()) {
            if ($this->exists()) {
                $sql = "UPDATE " . $this->table_name . " SET nombre = " . $this->var2str($this->nombre)
                    . ", limite = " . $this->var2str($this->limite)
                    . ", restringido = " . $this->var2str($this->restringido)
                    . " WHERE codclan = " . $this->var2str($this->codclan) . ";";
                return $this->db->exec($sql);
            }

            $sql = "INSERT INTO " . $this->table_name . " (nombre,limite,restringido) VALUES ("
                . $this->var2str($this->nombre) . ","
                . $this->var2str($this->limite) . ","
                . $this->var2str($this->restringido) . ");";
            if ($this->db->exec($sql)) {
                $this->codclan = $this->db->lastval();
                return TRUE;
            }
        }

        return FALSE;
    }

    /**
     * 
     * @return bool
     */
    public function delete()
    {
        return $this->db->exec("DELETE FROM " . $this->table_name . " WHERE codclan = " . $this->var2str($this->codclan) . ";");
    }

    /**
     * 
     * @return \clan_familiar[]
     */
    public function all()
    {
        $clanlist = array();

        $clanes = $this->db->select("SELECT * FROM " . $this->table_name . " ORDER BY nombre ASC;");
        if ($clanes) {
            foreach ($clanes as $c) {
                $clanlist[] = new clan_familiar($c);
            }
        }

        return $clanlist;
    }

    /**
     * 
     * @param string $query
     *
     * @return \clan_familiar[]
     */
    public function search($query)
    {
        $clanlist = array();
        $escapedq = $this->no_html(strtolower($query));

        $clanes = $this->db->select("SELECT * FROM " . $this->table_name
            . " WHERE lower(codclan) LIKE '%" . $escapedq . "%' OR lower(nombre) LIKE '%" . $escapedq . "%'"
            . " ORDER BY nombre ASC;");
        if ($clanes) {
            foreach ($clanes as $c) {
                $clanlist[] = new clan_familiar($c);
            }
        }

        return $clanlist;
    }

    /**
     * 
     * @param int $offset
     *
     * @return \albaran_cliente[]
     */
    public function last_albaranes($offset = 0)
    {
        $albalist = array();

        $data = $this->db->select_limit("SELECT * FROM albaranescli WHERE codcliente IN
         (SELECT codcliente FROM cliente2clan WHERE codclan = " . $this->var2str($this->codclan) . ")
            ORDER BY fecha DESC, codigo DESC", FS_ITEM_LIMIT, $offset);
        if ($data) {
            foreach ($data as $a) {
                $albalist[] = new albaran_cliente($a);
            }
        }

        return $albalist;
    }
}
